.H 1 "Assembler Window"
This window disassembles code and steps the processor at the instruction level.
The window can examine code generated by the compiler, 
or code for which no symbolic information is available.
From the line menus, breakpoints can be set at individual instructions.
Even when debugging at the source level, the Assembler window is useful
as it allows you to stop the process in the middle of
a complex statement and examine the intermediate results.
.H 2 "Assembler Layout"
The title bar identifies the window and displays the
process id number or name of the core dump file.
Each line in the window displays a disassembled instruction.
The instructions are ordered in the window by address, and have the format:
.DS I N
address: instruction
.DE
.P
An instruction's line menu lets you control the display
format of both the address and instruction.
Constants can be printed using symbolic labels or as numbers in
several different formats.
.P
If the symbolic format is enabled, addresses are displayed
in the same format as activation records in the Process window.
Addresses for which symbolic source line number and file information
is available are printed in the format:
.DS I N
file:linenumber+offset
.DE
.P
where offset is the difference in bytes between the
address of the first instruction implementing the source line,
and the address of the current instruction.
The offset may be displayed in either octal, hexadecimal,
or unsigned decimal, depending on the format settings.
Instructions in function prologues or in functions that do not have symbolic
source line and file information are displayed in the format:
.DS I N
function()+offset
.DE
.P
If the symbolic format is disabled addresses are displayed as absolute numbers.
The instruction syntax depends on the assembly language
used by the machine.
If an instruction has a breakpoint set on it
the displayed line starts with the special
character sequence ">>>".
.P
You can easily find the assembler intructions associated with a line of source
code by:
.AL 1
.LI
Selecting the source code line in the Source Text window and
choosing its "assembler" line menu entry,
causing the first instruction implementing the line to be disassembled.
.LI
Choosing one of the entries in the "next" menu for the
disassembled line in the Assembler window,
causing the instructions that follow to be disassembled and displayed.
.LE
.P
From the line number part of the address fields you can determine
how many instructions the compiler needed to implement the line of source code.
.H 2 "Assembler Menu Bar"
The "instr" menu controls the process
at the instruction level and is modeled after the "stmt" menu provided
in the Process window.
When debugging at the instruction level, it is recommended that the
pushpin in the "instr" menu be placed in the hole, so the menu remains on the
screen.
The "instr" menu contains the following entries:
.VL 11 1
.LI "run"
Continue a suspended application.
This is equivalent to choosing the "run" entry in 
the Process window's "stmt" menu.
See "Process Menu Bar" for the conditions that cause an
executing program to stop.
.LI "stop"
Suspend the application program.
.LI "current"
Disassemble and display the instruction corresponding
to the current program counter.
This is the only option available when a core dump is examined.
.LI "return"
Run the process at full speed
until the top activation record on the stack returns.
Useful for stepping out of functions you did not intend to step into.
When the process stops, the instruction corresponding to
the new program counter is disassembled and selected.
.LI "step over"
If the instruction is not a function call, step one instruction.
If the instruction is a function call, run the function at full
speed and stop at the first instruction after the call.
If you attempt to step over a function call that takes more than 15
seconds to execute (usually because the function call is complicated
or blocks in a system call), pi will stop the process.
.LI "step N"
Step the number of instructions specified. After each step, 
the number of remaining instructions is printed in the Process window
and any spy expressions are evaluated.
If any of the spy expressions change value, pi stops stepping. 
After the last step,
the instruction corresponding to the new program counter
is disassembled and selected.
.LE
.H 2 "Assembler Keyboard"
Syntax
.DS I N
 .=expression
.DE
.P
The window's keyboard language allows you to enter the address of
an instruction to disassemble.
When a line is typed, the expression is evaluated and the instruction
at the resulting address is disassembled.
.P
The assembler's expression grammar only accepts a subset of C expressions.
The expression may be constructed from global identifiers, integer
constants (C character, integer, and explicit long constants),
and the following C operators, listed in order of decreasing precedence:
.DS I N
Operator	Associativity
--------	-------------
() []		left to right
- &		right to left
* / %		left to right
+ -		left to right
.DE
.P
For example, to disassemble the instruction at the hexadecimal
address 0x2020, type:
.DS I N
 .=0x2020
.DE
.P
When a function name is used you must take the function's
address using the `&' operator rather than just using the function's name.
For example, to disassemble the instruction starting 100 bytes after
the start of the function main, type:
.DS I N
 .=&main+100
.DE
.P
The process registers are considered to be part of the global variable space,
so they may be used in assembler expressions.
For example, typing:
.DS I N
 .=$pc
.DE
.P
is equivalent to choosing the "current" entry in the "instr" menu.
.H 2 "Assembler Line Menus"
.VL 12 1
.LI "set bpt"
Set a breakpoint at the selected instruction.
The characters ">>>" are inserted at
the beginning of the line to indicate a breakpoint is present.
When an instruction breakpoint is hit, pi selects its
line in the Assembler window.
Conditional instruction breakpoints are not allowed.
.LI "clr bpt"
Clear the breakpoint set at the selected instruction.
This menu entry is only present for instructions that have breakpoints.
.LI "src text"
Open the Source Text window and select the line of source code that
generated the instruction.
This menu entry only appears for instructions that are in functions for 
which pi has symbolic source file and line information.
.LI "open frame"
Open the Frame window for the function that the selected line is in.
The Frame window can be used to examine the function's arguments
and local variables.
If the function does not have an activation record on the stack,
a warning message will be printed on the second line in the Process window.
If the function has been called recursively a
warning message will be printed in the Frame window when it is opened.
This entry is equivalent to the "open frame" entry in the Source Text
line menus.
.LI "next"
This menu has entries that allow 1 to 100 of the instructions
following the selected instruction to be disassembled. 
The formatting options for the disassembled instructions are inherited
from the selected instruction.
.LI "format"
This menu allows the display format of the disassembled
instruction to be changed.
.LI "refresh"
Reread the selected instruction's memory and disassemble it again.
This should not be necessary unless the instruction's memory has
been modified since the last time it was disassembled.
For example, patching an instruction from the Memory window or
disassembling a breakpoint location of a running process will cause
the disassembled instruction to change.
.LI "raw mem"
Open the Memory window and display the memory containing the
selected instruction. 
Useful if you would like to see the encoding of an instruction or
you would like to patch it.
.LE
.P
The "format" menu allows control over the format used to
display instructions.
If a format attribute is currently on, the menu entry allows you
to turn the attribute off, and if the attribute is on,
the menu allows you to turn the attribute off.
When a format menu entry is chosen,
the selected instruction is redisplayed with the new formatting options.
By default, the symbolic and hex formats are on, and the octal
and sign_dec formats are off.
.VL 18 1
.LI "octal on|off"
Turn on|off the displaying of integer constants as octal numbers.
.LI "sign_dec on|off"
Turn on|off the displaying of integer constants as signed decimal numbers.
.LI "hex on|off"
Turn on|off the displaying of integer constants as hexadecimal numbers.
.LI "symbolic on|off"
Turn on|off the symbolic displaying of addresses, registers,
and register offsets.
When a register containing a C register variable is printed,
the name of the variable will be printed in addition to the register.
Similarly, offsets to C local variables will be replaced
by the local variable names.
Depending on the implementation of the machine's disassembler,
the symbolic display of register and local variables may not be performed.
.LE
.P
Instructions displayed by choosing a "next N" entry in the "next" menu
inherit the display format of the instruction that generated the menu,
so to change the format for a block of displayed
instructions, change the format of the first instruction in the block
with the "format" menu, and then choose one of the "next N" entries
for that instruction.
.P
The following table shows how one Motorola 68020 instruction
is displayed when various formatting options are selected:
.DS I N
Format Flags		Displayed Line
--------------------	------------------------------------------
hex, symbolic		test1.c:21+0xC: addl d0,j(fp)
octal, symbolic		test1.c:21+014: addl d0,j(fp)
hex			0x2326: addl d0,0xC(fp)
sign_dec		8998: addl d0,12(fp)
octal			021446: addl d0,014(fp)
hex, octal, sign_dec	021446=0x2326=8998: addl d0,014=0xC=12(fp)
.DE
.P
Notice that when the symbolic option is on,
the displacement number in the register indirect with
displacement addressing mode is replaced with the name of the argument
or local variable.
If more than one of the hex, octal, and sign_dec options
are on, the character `=' is used to separate the display of the
same field in different formats. 

